% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-kernels.R
\docType{data}
\name{kernels}
\alias{kernels}
\title{Kernel functions}
\format{
An object of class \code{list} of length 5.
}
\usage{
kernels
}
\value{
a list of length 5 where each element is a kernel function.
}
\description{
Kernel functions for creating kernel based weights with \code{\link[=st_kernel_weights]{st_kernel_weights()}}
}
\details{
Supported kernels are below.

Formulas come from Anselin & Morrison's \href{https://spatialanalysis.github.io/lab_tutorials/Spatial_Weights_as_Distance_Functions.html#kernal-weights}{notes}.
\itemize{
\item \code{uniform}:  K(z) = 1/2 for |z|<1
\item \code{triangular}: K(z) = (1-|z|) for |z| < 1
\item \code{epanechnikov}: K(z) = (3/4)(1-z^2) for |z| < 1
\item \code{quartic}: K(z) = (15/16)*(1-(z/threshold)^2^)2 for |z| < 1
\item \code{gaussian}: K(z) = (2pi)^\{1/2\} * exp(-z^2/2)
}
}
\keyword{internal}
