% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_moran_test}
\alias{global_moran_test}
\title{Global Moran Test}
\usage{
global_moran_test(
  x,
  nb,
  wt,
  alternative = "greater",
  randomization = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{randomization}{default \code{TRUE}. Calculate variance based on randomization. If \code{FALSE}, under the assumption of normality.}

\item{...}{additional arguments passed to \code{\link[spdep:moran.mc]{spdep::moran.mc()}}}
}
\value{
an object of class \code{htest}
}
\description{
Global Moran Test
}
\examples{
nb <- guerry_nb$nb
wt <- guerry_nb$wt
x <- guerry_nb$crime_pers
global_moran_test(x, nb, wt)
}
\seealso{
Other global_moran: 
\code{\link{global_moran}()},
\code{\link{global_moran_bv}()},
\code{\link{global_moran_perm}()},
\code{\link{local_moran_bv}()}
}
\concept{global_moran}
