% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_arrow.R
\name{read_sf_dataset}
\alias{read_sf_dataset}
\title{Read an Arrow multi-file dataset and create \code{sf} object}
\usage{
read_sf_dataset(dataset, find_geom = FALSE)
}
\arguments{
\item{dataset}{a \code{Dataset} object created by \code{arrow::open_dataset}
or an \code{arrow_dplyr_query}}

\item{find_geom}{logical. Only needed when returning a subset of columns.
Should all available geometry columns be selected and added to to the
dataset query without being named? Default is \code{FALSE} to require
geometry column(s) to be selected specifically.}
}
\value{
object of class \code{\link[sf]{sf}}
}
\description{
Read an Arrow multi-file dataset and create \code{sf} object
}
\details{
This function is primarily for use after opening a dataset with
\code{arrow::open_dataset}. Users can then query the \code{arrow Dataset}
using \code{dplyr} methods such as \code{\link[dplyr]{filter}} or
\code{\link[dplyr]{select}}. Passing the resulting query to this function
will parse the datasets and create an \code{sf} object. The function
expects consistent geographic metadata to be stored with the dataset in
order to create \code{\link[sf]{sf}} objects.
}
\examples{
# read spatial object
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# create random grouping
nc$group <- sample(1:3, nrow(nc), replace = TRUE)

# use dplyr to group the dataset. \%>\% also allowed
nc_g <- dplyr::group_by(nc, group)

# write out to parquet datasets
# partitioning determined by dplyr 'group_vars'
write_sf_dataset(nc_g, path = file.path(tempdir(), "ds"))

list.files(file.path(tempdir(), "ds"), recursive = TRUE)

# open parquet files from dataset
ds <- arrow::open_dataset(file.path(tempdir(), "ds"))

# create a query. \%>\% also allowed
q <- dplyr::filter(ds, group == 1)

# read the dataset (piping syntax also works)
nc_d <- read_sf_dataset(dataset = q)

nc_d
plot(sf::st_geometry(nc_d))

}
\seealso{
\code{\link[arrow]{open_dataset}}, \code{\link[sf]{st_read}}, \code{\link{st_read_parquet}}
}
