% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos_measures}
\alias{geos_measures}
\alias{st_area}
\alias{geos_measures}
\alias{st_length}
\alias{geos_measures}
\alias{st_distance}
\title{Compute geometric measurements}
\usage{
st_area(x)

st_length(x, dist_fun = geosphere::distGeo)

st_distance(x, y, dist_fun, by_element = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{dist_fun}{function to be used for great circle distances of geographical coordinates; for unprojected (long/lat) data, this should be a distance function of package geosphere, or compatible to that; it defaults to \link[geosphere]{distGeo} in that case; for other data metric lengths are computed.}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}, defaults to \code{x}}

\item{by_element}{logical; if \code{TRUE}, return a vector with distance between the first elements of \code{x} and \code{y}, the second, etc. if \code{FALSE}, return the dense matrix with all pairwise distances.}
}
\value{
If the coordinate reference system of \code{x} was set, these functions return values with unit of measurement; see \link[units]{set_units}.

st_area returns the area of a geometry, in the coordinate reference system used; in case \code{x} is in degrees longitude/latitude, \link[geosphere]{areaPolygon} is used for area calculation.

st_length returns the length of a LINESTRING or MULTILINESTRING geometry, using the coordinate reference system.  POINT or MULTIPOINT geometries return zero, POLYGON or MULTIPOLYGON are converted into LINESTRING or MULTILINESTRING, respectively.

If \code{by_element} is \code{FALSE} a dense numeric matrix of dimension length(x) by length(y); otherwise a numeric vector of length \code{x} or \code{y}, the shorter one being recycled.
}
\description{
Compute Euclidian or great circle distance between pairs of geometries, the area of a geometry, or the length of a geometry.
}
\details{
Function \code{dist_fun} should follow the pattern of the distance function \link[geosphere]{distGeo}: the first two arguments must be 2-column point matrices, the third the semi major axis (radius, in m), the third the ellipsoid flattening.
}
\examples{
b0 = st_polygon(list(rbind(c(-1,-1), c(1,-1), c(1,1), c(-1,1), c(-1,-1))))
b1 = b0 + 2
b2 = b0 + c(-0.2, 2)
x = st_sfc(b0, b1, b2)
st_area(x)
dist_vincenty = function(p1, p2, a, f) geosphere::distVincentyEllipsoid(p1, p2, a, a * (1-f), f)
line = st_sfc(st_linestring(rbind(c(30,30), c(40,40))), crs = 4326)
st_length(line)
st_length(line, dist_fun = dist_vincenty)
p = st_sfc(st_point(c(0,0)), st_point(c(0,1)), st_point(c(0,2)))
st_distance(p, p)
st_distance(p, p, by_element = TRUE)
}
\seealso{
\link{st_dimension}
}
