% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R, R/db.R
\name{st_read}
\alias{st_read}
\alias{st_read}
\alias{read_sf}
\alias{st_read}
\alias{st_read_db}
\title{Read simple features or layers from file or database}
\usage{
st_read(dsn, layer, ..., options = NULL, quiet = FALSE,
  geometry_column = 1L, type = 0, promote_to_multi = TRUE,
  stringsAsFactors = default.stringsAsFactors(), int64_as_string = FALSE)

read_sf(..., quiet = TRUE, stringsAsFactors = FALSE)

st_read_db(conn = NULL, table = NULL, query = NULL, geom_column = NULL,
  EWKB, ...)
}
\arguments{
\item{dsn}{data source name (interpretation varies by driver - for some drivers, \code{dsn} is a file name, but may also be a folder,
or contain the name and access credentials of a database); in case of GeoJSON, \code{dsn} may be the character string holding the geojson data}

\item{layer}{layer name (varies by driver, may be a file name without extension); in case \code{layer} is missing,
\code{st_read} will read the first layer of \code{dsn}, give a warning and (unless \code{quiet = TRUE}) print a
message when there are multiple layers, or give an error if there are no layers in \code{dsn}.}

\item{...}{parameter(s) passed on to \link{st_as_sf}}

\item{options}{character; driver dependent dataset open options, multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference, or signaling no or multiple layers}

\item{geometry_column}{integer or character; in case of multiple geometry fields, which one to take?}

\item{type}{integer; ISO number of desired simple feature type; see details. If left zero, and \code{promote_to_multi}
is \code{TRUE}, in case of mixed feature geometry
types, conversion to the highest numeric type value found will be attempted. A vector with different values for each geometry column
can be given.}

\item{promote_to_multi}{logical; in case of a mix of Point and MultiPoint, or of LineString and MultiLineString, or of
Polygon and MultiPolygon, convert all to the Multi variety; defaults to \code{TRUE}}

\item{stringsAsFactors}{logical; logical: should character vectors be converted to factors?  The `factory-fresh' default
is \code{TRUE}, but this can be changed by setting \code{options(stringsAsFactors = FALSE)}.}

\item{int64_as_string}{logical; if TRUE, Int64 attributes are returned as string; if FALSE, they are returned as double
and a warning is given when precision is lost (i.e., values are larger than 2^53).}

\item{conn}{open database connection}

\item{table}{table name}

\item{query}{SQL query to select records; see details}

\item{geom_column}{character or integer: indicator of name or position of the geometry column; if not provided, the last column of type character is chosen}

\item{EWKB}{logical; is the WKB is of type EWKB? if missing, defaults to \code{TRUE} if \code{conn} is of class code{PostgreSQLConnection} or \code{PqConnection}, and to \code{FALSE} otherwise}
}
\value{
object of class \link{sf} when a layer was successfully read; in case argument \code{layer} is missing and
data source \code{dsn} does not contain a single layer, an object of class \code{sf_layers} is returned with the
layer names, each with their geometry type(s). Note that the number of layers may also be zero.
}
\description{
Read simple features from file or database, or retrieve layer names and their geometry type(s)

Read PostGIS table directly through DBI and RPostgreSQL interface, converting binary
}
\details{
for \code{geometry_column}, see also \url{https://trac.osgeo.org/gdal/wiki/rfc41_multiple_geometry_fields}; for \code{type}
values see \url{https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary}, but note that not every target value
may lead to successful conversion. The typical conversion from POLYGON (3) to MULTIPOLYGON (6) should work; the other
way around (type=3), secondary rings from MULTIPOLYGONS may be dropped without warnings. \code{promote_to_multi} is handled on a per-geometry column basis; \code{type} may be specified for each geometry column.

In case of problems reading shapefiles from USB drives on OSX, please see \url{https://github.com/r-spatial/sf/issues/252}.

\code{read_sf} and \code{write_sf} are aliases for \code{st_read} and \code{st_write}, respectively, with some
modified default arguments.
\code{read_sf} and \code{write_sf} are quiet by default: they do not print information
about the data source.
\code{write_sf} delete layers by default: it overwrites existing files.

if \code{table} is not given but \code{query} is, the spatial reference system (crs) of the table queried is only available in case it has been stored into each geometry record (e.g., by PostGIS, when using EWKB)

in case geom_column is missing: if table is missing, this function will try to read the name of the geometry column from table \code{geometry_columns}, in other cases, or when this fails, the geom_column is assumed to be the last column of mode character. If table is missing, the SRID cannot be read and resolved into a proj4string by the database, and a warning will be given.
}
\note{
The use of \code{system.file} in examples make sure that examples run regardless where R is installed:
typical users will not use \code{system.file} but give the file name directly, either with full path or relative
to the current working directory (see \link{getwd}). "Shapefiles" consist of several files with the same basename
that reside in the same directory, only one of them having extension \code{.shp}.
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
summary(nc) # note that AREA was computed using Euclidian area on lon/lat degrees

\dontrun{
  library(sp)
  example(meuse, ask = FALSE, echo = FALSE)
  st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse",
       layer_options = "OVERWRITE=true")
  st_meuse = st_read("PG:dbname=postgis", "meuse")
  summary(st_meuse)
}
# read geojson from string:
geojson_txt <- paste("{\\"type\\":\\"MultiPoint\\",\\"coordinates\\":",
   "[[3.2,4],[3,4.6],[3.8,4.4],[3.5,3.8],[3.4,3.6],[3.9,4.5]]}")
x = read_sf(geojson_txt)
x
\dontrun{
library(RPostgreSQL)
conn = dbConnect(PostgreSQL(), dbname = "postgis")
x = st_read_db(conn, "meuse", query = "select * from meuse limit 3;")
x = st_read_db(conn, table = "public.meuse")
print(st_crs(x)) # SRID resolved by the database, not by GDAL!
dbDisconnect(conn)}
}
