% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{valid}
\alias{valid}
\alias{st_make_valid}
\title{Make an invalid geometry valid}
\usage{
st_make_valid(x)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfg} or \code{sf}}
}
\value{
object of the same class as \code{x}
}
\description{
Make an invalid geometry valid
}
\details{
\code{st_make_valid} uses the \code{lwgeom_makevalid} method also used by the PostGIS command \code{ST_makevalid}. It is only available if the package was linked against liblwgeom, which is currently not the case for the binary CRAN distributions; see the package source code repository for instructions how to install liblwgeom. The example below shows how to run-time check the availability of liblwgeom.
}
\examples{
x = st_sfc(st_polygon(list(rbind(c(0,0),c(0.5,0),c(0.5,0.5),c(0.5,0),c(1,0),c(1,1),c(0,1),c(0,0)))))
if (!is.na(sf_extSoftVersion()["lwgeom"])) {
  suppressWarnings(st_is_valid(x))
  y = st_make_valid(x)
  st_is_valid(y)
  y \%>\% st_cast()
}
}
