% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_write}
\alias{st_write}
\title{Write simple features object to file or database}
\usage{
st_write(obj, dsn, layer = basename(dsn),
  driver = guess_driver_can_write(dsn), ..., dataset_options = NULL,
  layer_options = NULL, quiet = FALSE, factorsAsCharacter = TRUE)
}
\arguments{
\item{obj}{object of class \code{sf} or \code{sfc}}

\item{dsn}{data source name (interpretation varies by driver - for some drivers, dsn is a file name, but may also be a folder or contain a database name)}

\item{layer}{layer name (varies by driver, may be a file name without extension); if layer is missing, the \link{basename} of \code{dsn} is taken.}

\item{driver}{character; driver name to be used, if missing, a driver name is guessed from \code{dsn}; \code{st_drivers()} returns the drivers that are available with their properties; links to full driver documentation are found at \url{http://www.gdal.org/ogr_formats.html}.}

\item{...}{ignored}

\item{dataset_options}{character; driver dependent dataset creation options; multiple options supported.}

\item{layer_options}{character; driver dependent layer creation options; multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference}

\item{factorsAsCharacter}{logical; convert \code{factor} objects into character strings (default), else into numbers by \code{as.numeric}.}
}
\description{
Write simple features object to file or database
}
\details{
columns (variables) of a class not supported are dropped with a warning.
}
\examples{
if (Sys.getenv("USER") \%in\% c("edzer", "travis")) { # load meuse to postgis
 library(sp)
 example(meuse, ask = FALSE, echo = FALSE)
 st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse_sf",
   layer_options = c("OVERWRITE=yes", "LAUNDER=true"))
 demo(nc, ask = FALSE)
 st_write(nc, "PG:dbname=postgis", "sids", layer_options = "OVERWRITE=true")
}
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_write(nc, "nc.shp")
}
\seealso{
\link{st_drivers}
}

