% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-item.R
\name{Item}
\alias{Item}
\title{R6 Class Representing an Item}
\description{
Base class for describing objects:
Project, Task, App, File, etc.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{response}}{Raw response from the request.}

\item{\code{href}}{Item's API request URL.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Item-new}{\code{Item$new()}}
\item \href{#method-Item-reload}{\code{Item$reload()}}
\item \href{#method-Item-clone}{\code{Item$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Item-new"></a>}}
\if{latex}{\out{\hypertarget{method-Item-new}{}}}
\subsection{Method \code{new()}}{
Create a new Item object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Item$new(href = NA, response = NA, auth = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{href}}{Item's API request URL.}

\item{\code{response}}{Raw API response.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Item-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Item-reload}{}}}
\subsection{Method \code{reload()}}{
Reload the Item (resource).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Item$reload(cls, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cls}}{Item class object.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'limit', 'offset', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Item-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Item-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Item$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
