\name{runModels}
\alias{runModels}
\title{
Run a spatial SEM analysis
}
\description{
Given a path model (spatial_model) specified using lavaan syntax, and a list object containing covariance matrices generated by make.covar, runs an sem model using function sem from the lavaan package for each lag distance bin.
}
\usage{
runModels(spatial_model,covdata)
}

\arguments{
  \item{spatial_model}{
a path model specified using lavaan syntax. See the \code{\link{lavaan}} help pages for details.
}
  \item{covdata}{
a list object containing covariance matrices and other descriptors as produced by make.covar
}
}
\details{
Given a path model (spatial_model) specified using lavaan syntax, and a list object containing covariance matrices generated by make.covar, runs an sem model using function sem from the lavaan package for each lag distance bin. Produces a list object containing the model results.
}
\value{

\item{1}{a table of model fit estimates for each model. Values available in this table include the following: "fmin","chisq","df","pvalue","baseline.chisq","baseline.df","baseline.pvalue","cfi","tli","nnfi",	"rfi","nfi","pnfi","ifi","rni","logl","unrestricted.logl","npar","aic","bic","ntotal","bic2","rmsea","rmsea.ci.lower","rmsea.ci.upper","rmsea.pvalue","rmr","rmr_nomean","srmr","srmr_nomean","cn_05","cn_01","gfi","agfi","pgfi","mfi","ecvi". See the lavaan documentation for an explanation of each value.}
\item{2}{table containing a vector of parameter numbers and a character vector containing the names of the paths included in each model.}
\item{3}{a table of unstandardized path coefficient estimates for each path in each model}
\item{4}{standard error of unstandardized path coefficient estimates for each path in each model}
\item{5}{p-values for each unstandardized path coefficient estimate for each path in each model}
\item{6}{standardized parameter estimates for each path in each model}
\item{7}{character vector containing list of names of dependent variables within the models}
\item{8}{r-square values for each dependent variable in each model}
\item{9}{names of each path for which there is a modification index value}
\item{10}{modification index values for each potential path addition for each model}
\item{11}{a copy of the bin.summary table in the input covdata object}
}
\references{
Lamb, E. G., K. Mengersen, K. J. Stewart, U. Attanayake, and S. D. Siciliano. Submitted. Spatially explicit structural equation modeling. Ecology.

Rosseel, Y. 2012 lavaan: an R package for structural equation modeling. \emph{Journal of Statistical Software} \bold{48}:1-36.
}
\author{
Eric Lamb
}
\note{
Should model convergence fail for certain lag bins, those bins will be skipped and no results written.
}


\seealso{
\code{\link{sem}}, \code{\link{make.covar}}, \code{\link{modelsummary}}, \code{\link{plotmodelfit}}, \code{\link{plotpath}}
}
\examples{

data=truelove
truelove_red<-truelove[c(1:60),]
distancematrix<-calc.dist(truelove_red)
Truelove_bins<-make.bin(distancematrix,type="ALL",p.dist=10)
binsize<-Truelove_bins[1][[1]] #truelove lowland bin sizes
binname<-Truelove_bins[2][[1]] #truelove lowland bin names

plotbin(distancematrix,binsize)

covariances<-make.covar(truelove_red,distancematrix,binsize,binname)
covariances

# path model for the truelove dataset
spatial_model<-'
	Gram ~ Moisture
	N_Fix ~ Bryoph + Lich + SoilCrust
	SoilCrust ~ Bryoph + Lich + Gram + Shrubs + Forbs	
	Bryoph ~ Gram + Shrubs + Forbs + Moisture
	Lich ~ Moisture + Forbs + Gram + Shrubs + Bryoph
	Forbs ~ Moisture
	Gram ~~ Forbs
	Shrubs ~ Moisture	
	Gram ~~ Shrubs
	Shrubs ~~ Forbs
	'

results<-runModels(spatial_model,covariances)
plotmodelfit(results,rmsea_err=FALSE)
}
\keyword{ spatial }

