% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{sst_au_start}
\alias{sst_au_start}
\title{Start a website audit}
\usage{
sst_au_start(api_token, project_id = NULL)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{project_id}{(required) ID of the project in Serpstat.}
}
\value{
Returns the ID of the audit report.
}
\description{
Starts a project website audit with the current audit settings. Uses default
audit settings if no settings were changed.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/510-audit-start-auditsitestart/}{here}.
}

\section{API credits consumption}{
 1 audit credit for each checked page.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_au_start(
  api_token  = api_token,
  project_id = 12345
  )$data$reportId
}
}
