% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll.R
\name{.nll}
\alias{.nll}
\title{Calculate negative log-likelihood}
\usage{
.nll(log.lambda, ...)
}
\arguments{
\item{log.lambda}{natural logarithm of incidence rate}

\item{...}{
  Arguments passed on to \code{\link[=log_likelihood]{log_likelihood}}
  \describe{
    \item{\code{pop_data}}{a \code{\link[=data.frame]{data.frame()}} with cross-sectional serology data per antibody and age, and additional columns}
    \item{\code{antigen_isos}}{Character vector listing one or more antigen isotypes. Values must match \code{pop_data}.}
    \item{\code{curve_params}}{a \code{\link[=data.frame]{data.frame()}} containing MCMC samples of parameters from the Bayesian posterior distribution of a longitudinal decay curve model. The parameter columns must be named:
\itemize{
\item \code{antigen_iso}: a \code{\link[=character]{character()}} vector indicating antigen-isotype combinations
\item \code{iter}: an \code{\link[=integer]{integer()}} vector indicating MCMC sampling iterations
\item \code{y0}: baseline antibody level at \eqn{t=0} (\eqn{y(t=0)})
\item \code{y1}: antibody peak level (ELISA units)
\item \code{t1}: duration of infection
\item \code{alpha}: antibody decay rate (1/days for the current longitudinal parameter sets)
\item \code{r}: shape factor of antibody decay
}}
    \item{\code{noise_params}}{a \code{\link[=data.frame]{data.frame()}} (or \code{\link[tibble:tibble]{tibble::tibble()}}) containing the following variables, specifying noise parameters for each antigen isotype:
\itemize{
\item \code{antigen_iso}: antigen isotype whose noise parameters are being specified on each row
\item \code{nu}: biological noise
\item \code{eps}: measurement noise
\item \code{y.low}: lower limit of detection for the current antigen isotype
\item \code{y.high}: upper limit of detection for the current antigen isotype
}}
    \item{\code{verbose}}{logical: if TRUE, print verbose log information to console}
  }}
}
\value{
the negative log-likelihood of the data with the current parameter values
}
\description{
Same as \code{\link[=log_likelihood]{log_likelihood()}}, except negated and requiring lambda on log scale (used in combination with \code{nlm()}, to ensure that the optimization search doesn't stray into negative values of \code{lambda}).
}
\keyword{internal}
