% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.seroincidence.R
\name{autoplot.seroincidence}
\alias{autoplot.seroincidence}
\title{Plot the log-likelihood curve for the incidence rate estimate}
\usage{
\method{autoplot}{seroincidence}(object, log_x = FALSE, ...)
}
\arguments{
\item{object}{a \code{seroincidence} object (from \code{\link[=est.incidence]{est.incidence()}})}

\item{log_x}{should the x-axis be on a logarithmic scale (\code{TRUE}) or linear scale (\code{FALSE}, default)?}

\item{...}{unused}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Plot the log-likelihood curve for the incidence rate estimate
}
\examples{


library(dplyr)
library(ggplot2)
\donttest{
xs_data <- load_pop_data("https://osf.io/download//n6cp3/") \%>\%
  clean_pop_data()

curve <- load_curve_params("https://osf.io/download/rtw5k/") \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG")) \%>\%
  slice(1:100, .by = antigen_iso) # Reduce dataset for the purposes of this example

noise <- load_noise_params("https://osf.io/download//hqy4v/")

est1 <- est.incidence(
  pop_data = xs_data \%>\% filter(Country == "Pakistan"),
  curve_param = curve,
  noise_param = noise \%>\% filter(Country == "Pakistan"),
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  build_graph = TRUE
)

# Plot the log-likelihood curve
autoplot(est1)
}
}
