% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMaybeRel.R
\name{GetMaybeRel}
\alias{GetMaybeRel}
\title{Find putative relatives}
\usage{
GetMaybeRel(
  GenoM = NULL,
  SeqList = NULL,
  Pedigree = NULL,
  LifeHistData = NULL,
  ParSib = "par",
  Complex = "full",
  Err = 1e-04,
  ErrFlavour = "version2.0",
  MaxMismatch = NA,
  Tassign = 0.5,
  MaxPairs = 7 * nrow(GenoM),
  DumPrefix = c("F0", "M0"),
  quiet = FALSE
)
}
\arguments{
\item{GenoM}{matrix with genotype data, size nInd x nSnp}

\item{SeqList}{list with output from \code{\link{sequoia}}. If provided, the
elements `Specs', `AgePriors' and 'LifeHist' are used, and all other input
parameters except 'GenoM', 'ParSib' and 'quiet' are ignored.}

\item{Pedigree}{dataframe with id - dam - sire in columns 1-3}

\item{LifeHistData}{dataframe with columns id - sex (1=female, 2=male,
3=unknown) - birth year}

\item{ParSib}{either 'par' to check for putative parent-offspring pairs only,
or 'sib' to check for all types of first and second degree relatives. When
'par', all pairs are returned that are more likely parent-offspring than
unrelated, including pairs that are even more likely to be otherwise
related.}

\item{Complex}{either "full" (default), "simp" (simplified, no explicit
consideration of inbred relationships), "mono" (monogamous) or "herm"
(hermaphrodites, otherwise like "full").}

\item{Err}{estimated genotyping error rate, as a single number or 3x3 matrix.
If a matrix, this should be the probability of observed genotype (columns)
conditional on actual genotype (rows). Each row must therefore sum to 1.}

\item{ErrFlavour}{function that takes \code{Err} as input, and returns a 3x3
matrix of observed (columns) conditional on actual (rows) genotypes, or
choose from inbuilt ones as used in sequoia 'version2.0', 'version1.3', or
'version1.1'. Ignored if \code{Err} is a matrix. See \code{\link{ErrToM}}.}

\item{MaxMismatch}{DEPRECATED AND IGNORED. Now calculated using
\code{\link{CalcMaxMismatch}}.}

\item{Tassign}{minimum LLR required for acceptance of proposed relationship,
relative to next most likely relationship. Higher values result in more
conservative assignments. Must be zero or positive.}

\item{MaxPairs}{The maximum number of putative pairs to return.}

\item{DumPrefix}{character vector of length 2 with prefixes for dummy dams
(mothers) and sires (fathers) used in \code{Pedigree}.}

\item{quiet}{suppress messages}
}
\value{
A list with
  \item{MaybeParent or MaybeRel}{A dataframe with non-assigned likely
    relatives, with columns ID1 - ID2 - TopRel - LLR - OH - BirthYear1 -
    BirthYear2 - AgeDif - Sex1 - Sex2 - SNPdBoth}
  \item{MaybeTrio}{A dataframe with non-assigned parent-parent-offspring
    trios, with columns id - parent1 - parent2 - LLRparent1 - LLRparent2 -
    LLRpair - OHparent1 - OHparent2 - MEpair - SNPd.id.parent1 -
    SNPd.id.parent2}
The following categories are used in column 'TopRel', indicating the most
likely relationship category:
\item{PO}{Parent-Offspring}
\item{FS}{Full Siblings}
\item{HS}{Half Siblings}
\item{GP}{GrandParent - grand-offspring}
\item{FA}{Full Avuncular (aunt/uncle)}
\item{2nd}{2nd degree relatives, not enough information to distinguish between
  HS,GP and FA}
\item{Q}{Unclear, but probably 1st, 2nd or 3rd degree relatives}
}
\description{
Identify pairs of individuals likely to be related, but not
  assigned as such in the provided pedigree.
}
\examples{
\dontrun{
data(SimGeno_example, LH_HSg5, package="sequoia")
SeqOUT <- sequoia(GenoM = SimGeno_example,
                  LifeHistData = LH_HSg5, MaxSibIter = 0)
MaybePO <- GetMaybeRel(GenoM = SimGeno_example,
                      SeqList = SeqOUT)

Maybe <- GetMaybeRel(GenoM = SimGeno_example,
                      Pedigree = SeqOUT$PedigreePar, ParSib="sib")
}

}
