% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{seqmissIplot}
\alias{seqmissIplot}
\title{Plot all the patterns of missing data.}
\usage{
seqmissIplot(data, var = NULL, with.complete = TRUE, ...)
}
\arguments{
\item{data}{a data.frame where missing data are coded as \code{NA} or 
a state sequence object built with \link[TraMineR]{seqdef} function}

\item{var}{the list of columns containing the trajectories. 
Default is NULL, i.e. all the columns.}

\item{with.complete}{a logical stating if complete trajectories 
should be included or not in the plot}

\item{...}{parameters to be passed to the \link[TraMineR]{seqIplot}function}
}
\description{
#' @description
Plot function that renders all the patterns of missing data. This
function is based on the \link[TraMineR]{seqIplot} function.
}
\examples{
# Plot all the patterns of missing data

seqmissIplot(gameadd, var=1:4)

# Plot all the patterns of missing data discarding 
# complete trajectories

seqmissIplot(gameadd, var=1:4, with.missing = FALSE)
}
\author{
Kevin Emery
}
