\name{seqMetaExample}
\alias{seqMetaExample}
\alias{Z1}
\alias{Z2}
\alias{pheno1}
\alias{pheno2}
\alias{kins}
\docType{data}
\title{
%%   ~~ data name/kind ... ~~
Example data for illustrating seqMeta
}
\description{
Contains simulated data for two cohorts.  See the example for the exact code used to generate the data.
}
\usage{data(seqMetaExample)}
\format{
	This contains simulated data for two cohorts to illustrate seqMeta package
  \describe{
    \item{\code{Z1},\code{Z2}}{
    	Genotype matrices for cohorts 1 and 2 respectively
    }
    \item{\code{pheno1},\code{pheno2}}{
    	phenotype matrices for cohorts 1 and 2 respectively
    }
    \item{kins}{
    	The kinship matrix for cohort 2
    }
  }
}

\examples{
#Data generated by
\dontrun{
set.seed(20)
n <- 600 #observations per cohort
d <- 2000 #SNPs
k <- 100 #genes

##### First cohort of unrelated individuals:
Z1 <- replicate(d,rbinom(n,2,rbeta((n),3,200)))

## assign SNP id's to the columns 
colnames(Z1) <- sample(d+50,d) + 1e6

pheno1 <-  data.frame("y" = rnorm(n), "sex"=rep(1:2,(n/2)), "bmi"=rnorm(n,25,2),
	"ybin" = rbinom(n,1,.5), "time"=rpois(n,5), "status"=rbinom(n,1,.9))

genes <- paste0("gene",1:k)
SNPInfo <- data.frame("Name" =1:(d+50) + 1e6, "gene" = sort(sample(genes,d+50,replace=T)))

#####Second cohort of family data:
# 150 families of size 4
require(kinship2)
fullped<-data.frame(famid=rep(1:(n/4),each=4),id=10001:(10000+n),fa=rep(0,n),mo=rep(0,n))
fullped$fa[(1:(n/4))*4-1]<-fullped$fa[(1:(n/4))*4]<-(1:(n/4))*4+9997
fullped$mo[(1:(n/4))*4-1]<-fullped$mo[(1:(n/4))*4]<-(1:(n/4))*4+9998
kins = makekinship(fullped$famid, fullped$id, fullped$fa, fullped$mo)

## generate a phenotype with 20\% `heritability': 
pheno2<-data.frame("id"=10001:(10000+n),"y"=t(rnorm(n)\%*\%chol(0.2*2*as.matrix(kins) + 
	0.8*diag(n))),"sex"=rep(1:2,(n/2)),"bmi"=rnorm(n,25,2))

Z2 <- replicate(d,rbinom(n,2,rbeta((n/4),3,200)[fullped$famid]))
colnames(Z2) <- sample(d+50,d) + 1e6
}
}
\keyword{datasets}