% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_coefs}
\alias{bootstrap_coefs}
\alias{bootstrap_coefs.nhmm}
\alias{bootstrap_coefs.mnhmm}
\title{Bootstrap Sampling of NHMM Coefficients}
\usage{
bootstrap_coefs(model, ...)

\method{bootstrap_coefs}{nhmm}(
  model,
  nsim,
  type = c("nonparametric", "parametric"),
  append = FALSE,
  ...
)

\method{bootstrap_coefs}{mnhmm}(
  model,
  nsim,
  type = c("nonparametric", "parametric"),
  append = FALSE,
  ...
)
}
\arguments{
\item{model}{An \code{nhmm} or \code{mnhmm} object.}

\item{...}{Additional arguments to \code{\link[=estimate_nhmm]{estimate_nhmm()}} or \code{\link[=estimate_mnhmm]{estimate_mnhmm()}}.}

\item{nsim}{number of bootstrap samples.}

\item{type}{Either \code{"nonparametric"} (default) or \code{"parametric"}, to define
whether nonparametric or parametric bootstrap should be used. The former samples
sequences with replacement, whereas the latter simulates new datasets based
on the model.}

\item{append}{If \code{TRUE}, in case the model already contains
bootstrap samples, new samples are appended to \code{model$boot}. If \code{FALSE}
(default), old samples are discarded.}

\item{method}{Estimation method used in bootstrapping. Defaults to \code{"EM-DNM"}.}
}
\value{
The original model with additional element \code{model$boot}.
}
\description{
It is possible to parallelize the bootstrap runs using the \code{future} package,
e.g., by calling \code{future::plan(multisession, workers = 2)} before
\code{bootstrap_coefs()}. See \code{\link[future:plan]{future::plan()}} for details.
}
\details{
\code{bootstrap_coefs()} is compatible with \code{progressr} package, so you can use
\code{progressr::with_progress(bootstrap_coefs(fit))} to track the progress of
bootstrapping.
}
