% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mhmm.R
\name{summary.mhmm}
\alias{summary.mhmm}
\title{Summary method for mixture hidden Markov models}
\usage{
\method{summary}{mhmm}(
  object,
  parameters = FALSE,
  conditional_se = TRUE,
  log_space = FALSE,
  ...
)
}
\arguments{
\item{object}{Mixture hidden Markov model of class \code{mhmm}.}

\item{parameters}{Whether or not to return transition, emission, and
initial probabilities. \code{FALSE} by default.}

\item{conditional_se}{Return conditional standard errors of coefficients.
See \code{\link{vcov.mhmm}} for details. \code{TRUE} by default.}

\item{log_space}{Make computations using log-space instead of scaling for greater
numerical stability at cost of decreased computational performance. Default is \code{FALSE}.}

\item{...}{Further arguments to \code{\link{vcov.mhmm}}.}
}
\value{
\describe{
   \item{transition_probs}{Transition probabilities. Only returned if \code{parameters = TRUE}.}
   \item{emission_probs}{Emission probabilities. Only returned if \code{parameters = TRUE}.}
   \item{initial_probs}{Initial state probabilities. Only returned if \code{parameters = TRUE}.}
   \item{logLik}{Log-likelihood.}
   \item{BIC}{Bayesian information criterion.}
   \item{most_probable_cluster}{The most probable cluster according to posterior probabilities.}
   \item{coefficients}{Coefficients of covariates.}
   \item{vcov}{Variance-covariance matrix of coefficients.}
   \item{prior_cluster_probabilities}{Prior cluster probabilities
   (mixing proportions) given the covariates.}
   \item{posterior_cluster_probabilities}{Posterior cluster membership probabilities.}
   \item{classification_table}{Cluster probabilities (columns) by the most probable cluster (rows).}
  }
}
\description{
Function \code{summary.mhmm} gives a summary of a mixture hidden Markov model.
}
\details{
The \code{summary.mhmm} function computes features from a mixture hidden Markov
model and stores them as a list. A \code{print} method prints summaries of these:
log-likelihood and BIC, coefficients and standard errors of covariates, means of prior
cluster probabilities, and information on most probable clusters.
}
\examples{
# Loading mixture hidden Markov model (mhmm object)
# of the biofam data
data("mhmm_biofam")

# Model summary
summary(mhmm_biofam)


}
\seealso{
\code{\link{build_mhmm}} and \code{\link{fit_model}} for building and
  fitting mixture hidden Markov models; and
  \code{\link{mhmm_biofam}} for information on the model used in examples.
}
