% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.mhmm.R
\name{vcov.mhmm}
\alias{vcov.mhmm}
\title{Variance-Covariance Matrix for Coefficients of Covariates of Mixture Hidden Markov Model}
\usage{
\method{vcov}{mhmm}(object, conditional = TRUE, threads = 1,
  log_space = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{mhmm}.}

\item{conditional}{If \code{TRUE} (default), the standard errors are
computed conditional on other model parameters. See details.}

\item{threads}{Number of threads to use in parallel computing. Default is 1.}

\item{log_space}{Make computations using log-space instead of scaling for greater
numerical stability at cost of decreased computational performance. Default is \code{FALSE}.}

\item{...}{Additional arguments to function \code{jacobian} of \code{numDeriv} package.}
}
\value{
Matrix containing the variance-covariance matrix of coefficients.
}
\description{
Returns the asymptotic covariances matrix of maximum likelihood estimates of
the coefficients corresponding to the explanatory variables of the model.
}
\details{
The conditional standard errors are computed using
analytical formulas by assuming that the coefficient estimates are not correlated with
other model parameter estimates (or that the other parameters are assumed to be fixed).
This often underestimates the true standard errors, but is substantially
faster approach for preliminary analysis. The non-conditional standard errors
are based on the numerical approximation of the full Hessian of the coefficients
and the model parameters corresponding to nonzero probabilities.
Computing the non-conditional standard errors can be slow for large models as
the Jacobian of analytical gradients is computed using finite difference approximation.
}

