% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_se.R
\name{spread_se}
\alias{spread_se}
\title{Collect values from blocks of rows into columns.}
\usage{
spread_se(data, key, value, ..., fill = NA, convert = FALSE, drop = TRUE,
  sep = NULL)
}
\arguments{
\item{data}{data.frame to take values from.}

\item{key}{character, name for existing column to get new column names from.}

\item{value}{character, name for existing column to take values from.}

\item{...}{not used, force later arguments to bind by name.}

\item{fill}{passed to spread.}

\item{convert}{passed to spread.}

\item{drop}{passed to spread.}

\item{sep}{passed to spread.}
}
\value{
converted data.
}
\description{
Standared inteface to \code{\link[tidyr]{spread}}.
Take values from the columns named in the \code{columns} argument and
move them into blocks of rows, placing values in the new column specified by \code{value}
and indicating which column each value came from in the new column specified by \code{key}.
}
\examples{

d <- wrapr::build_frame(
    'id', 'name_for_new_column' , 'value_to_take' |
    1   , 'col1'                , 'a'             |
    1   , 'col2'                , '10'            |
    2   , 'col1'                , 'b'             |
    2   , 'col2'                , '20'            )
spread_se(d,
   key = 'name_for_new_column',
   value = 'value_to_take')

}
\seealso{
\code{\link[tidyr]{spread}}, \code{\link{gather_se}}
}
