% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stmtPlanner.R
\name{partition_mutate_qt}
\alias{partition_mutate_qt}
\title{Partition a sequence of mutate commands into longest ordered no create/use blocks.}
\usage{
partition_mutate_qt(...)
}
\arguments{
\item{...}{mutate expressions with := used for assignment.}
}
\value{
ordered list of mutate_se assignment blocks
}
\description{
The idea is: we assume the sequence of expressions is in a valid order
(all items available before use).  This function partitions the expressions
into ordered longest "no new value used blocks" by greedily scanning forward
and skipping any expressions that either use a value created in the current block
or require a value not yet produced.
For an example please see \url{http://winvector.github.io/FluidData/partition_mutate.html}.
}
\details{
Note: unlike \code{\link{mutate_nse}} \code{partition_mutate_qt} does not perform
substitutions.
}
\examples{

plan <- partition_mutate_qt(a1 := 1, b1 := a1, a2 := 2, b2 := a1 + a2)
print(plan)
d <- data.frame(x = 1) \%.>\% mutate_seb(., plan)
print(d)


}
