% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_se.R
\name{mutate_se}
\alias{mutate_se}
\title{mutate standard evaluation interface.}
\usage{
mutate_se(.data, mutateTerms, splitTerms = TRUE, env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{mutateTerms}{character vector of column expressions to mutate by.}

\item{splitTerms}{logical, if TRUE into separate mutates (if FALSE instead, pass all at once to dplyr).}

\item{env}{environment to work in.}
}
\value{
.data with altered columns.
}
\description{
Mutate a data frame by the mutateTerms.  Accepts arbitrary text as
mutateTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
Terms are vectors or lists of the form "lhs := rhs".
Semantics are: terms are evaluated left to right if splitTerms==TRUE (the default).
}
\examples{


resCol1 <- "Sepal_Long"
limit <- 3.5

datasets::iris \%.>\%
  mutate_se(., c(resCol1 := "Sepal.Length >= 2 * Sepal.Width",
                 "Petal_Short" := "Petal.Length <= limit")) \%.>\%
  head(.)


}
\seealso{
\code{\link{mutate_nse}}, \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{mutate_at}}, \code{\link[wrapr]{:=}}
}
