% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{reset}
\alias{reset}
\title{Re-initialize a topic model}
\usage{
reset(x)
}
\arguments{
\item{x}{a model created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}} function and
estimated with \code{\link[=grow]{grow()}}}
}
\value{
a \code{sentopicmodel} of the relevant model class, with the iteration count
reset to zero and re-initialized assignment of latent variables.
}
\description{
This function is used re-initialize  a topic model, as if it was
created from \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or another model. The re-initialized model
retains its original parameter specification.
}
\examples{
model <- LDA(ECB_press_conferences_tokens)
model <- grow(model, 10)
reset(model)
}
\seealso{
\code{\link[=grow]{grow()}}
}
\author{
Olivier Delmarcelle
}
