% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{measures_delete}
\alias{measures_delete}
\title{Delete sentiment measures}
\usage{
measures_delete(sentomeasures, toDelete, do.combine = TRUE)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{toDelete}{a \code{character} vector of the lexicon, feature and time weighting scheme names, to indicate which
measures need to be deleted. One can also supply a \code{list} of such \code{character} vectors, in which case
\code{do.combine = TRUE} is set automatically, such that the separately specified combinations are deleted.}

\item{do.combine}{a \code{logical} indicating if only measures for which all (\code{do.combine = TRUE}) or at least one
(\code{do.combine = FALSE}) from \code{toDelete} should occur in each sentiment measure's name for deletion. If
\code{do.combine = TRUE}, the \code{toDelete} argument can only consist of one lexicon, one feature, and one time weighting
scheme at maximum.}
}
\value{
A modified \code{sentomeasures} object, with the required sentiment measures deleted, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Deletes all sentiment measures which include either all of the given deletion components combined,
or those who's name consist of at least one of the deletion components.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# different deletions
del1 <- measures_delete(sentomeasures, c("equal_weight"))
del2 <- measures_delete(sentomeasures, c("equal_weight", "linear"), do.combine = FALSE)
del3 <- measures_delete(sentomeasures, c("linear", "LM_en"))
del4 <- measures_delete(sentomeasures, list(c("linear", "wsj"), c("linear", "economy")))

}
\seealso{
\code{\link{measures_select}}
}
\author{
Samuel Borms
}
