% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_indices.R
\name{sobol_compute_secondJ}
\alias{sobol_compute_secondJ}
\title{Computation of second-order Sobol' indices using the
Jansen 1999 estimators.}
\usage{
sobol_compute_secondJ(Y_A, Y_B, Y_ABi, Y_ABj, Y_ABij)
}
\arguments{
\item{Y_A}{Numeric vector, model output of the A matrix.}

\item{Y_B}{Numeric vector, model output of the B matrix.}

\item{Y_ABi}{Numeric vector, model output of the AB matrix,
where all the columns come from the A matrix except the i-th,
which comes from the B matrix.}

\item{Y_ABj}{Numeric vector, model output of the AB matrix,
where all the columns come from the A matrix except the j-th,
which comes from the B matrix.}

\item{Y_ABij}{Numeric vector, model output of the AB matrix,
where all the columns come from the A matrix except the i-th
and the j-th, which come from the B matrix.}
}
\value{
The second-order indices
}
\description{
Computation of second-order Sobol' indices using the
Jansen 1999 estimators.
}
