% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_functions.R
\name{start_trace}
\alias{start_trace}
\alias{end_trace}
\alias{clean_trace}
\alias{trace_function}
\alias{clean_traces}
\title{Trace functions which create files}
\usage{
start_trace(trace_files, trace_funname)

end_trace(tracename)

clean_trace(tracename)

trace_function(trace_fun, trace_files, trace_funname = NA, ...)

clean_traces(trace_funname = NA)
}
\arguments{
\item{trace_files}{Vector of the files intended to be created by \code{fun}
(for now, providing it is mandatory). Also temporary files can be indicated
here.}

\item{trace_funname}{The name of the function to be run (in \link{start_trace}) or
to be cleaned (in \link{clean_traces}; if NA, all the traces are cleaned).}

\item{tracename}{The path of the text file containing the log information
generated by \link{start_trace}.}

\item{trace_fun}{The function to be run.}

\item{...}{Arguments of the function \code{fun}}
}
\value{
NULL (the function is called for its side effects)
}
\description{
Some functions create output files during their execution;
some of them are slow, so the probability that something goes wrong
during their execution is not null, with the consequence that output
files are incomplete, or that undesired temporary files are left on
the filesystem.

This functions is though to manage these situations.

\link{trace_function} runs a function and checks if errors occur during its execution;
in this case, the files created by it are deleted (only if the timestamp
of the files is subsequent to the time of execution of the function).
If the code interrupts before the function ends, the paths of the files
intended to be created by the function are saved within the package, so that
they can be easily deleted in a second time; to do it, simply
run \link{clean_traces}.

Other intermediate functions are used internally:
\link{start_trace} saves the paths of the files intended to be created within
a text file;
\link{end_trace} deletes this text file (it is used by \link{trace_function} when
a function stops without errors);
\link{clean_trace} deletes this text file and the intended output files (it is
used by \link{trace_function} when a function stops with errors).
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
