# semptools

Helper functions for modifying (postprocessing) plots generated by `semPlot::semPaths()` from the `semPlot` package.

# Installation

The latest version can be installed by `remotes::install_github()`:

```
remotes::install_github("sfcheung/semptools")
```

To read the guides (vignettes) on how to use the functions, you can build the vignettes locally when installing the package: 

```
remotes::install_github("sfcheung/semptools", build_vignettes = TRUE)
```

You can also find the guides under *Articles* of the [Github page](https://sfcheung.github.io/semptools/) of this package.

# Background

`semPlot::semPaths()` is a very useful function for visualizing structural equation models. We use it a lot. The output is a `qgraph` object which is highly customizable. Our area is in psychology and some users in this area may not know how to customize the graphs in aspects relevant to psychology. Therefore, we think it would be useful for users in psychology, including us, to have some functions for customizing the graphs from `semPlot::semPaths()`, without knowing the technical details of `qgraph`.

# Philosophy

We think about the tasks we usually want to do with an `semPlot::semPaths()` graph, and write one function for each task. We write the functions such that all of them work by postprocessing a `semPlot::semPaths()` graph: receive an `semPlot::semPaths()` graph, modify it, and return a modified `semPlot::semPaths()` graph. This also allows users to use the `%>%` (pipe) operator from the `magrittr` package or
the native pipe operator `|>` available since R 4.1.x to chain together modifications. For example:

```
modified_graph <- original_graph %>%
                    task_1() %>%
                    task_2(other_arguments) %>%
                    task_3
```

In psychology, two typical models are confirmatory factor analysis model and structural models with latent factors. Therefore, we also wrote two functions, one for each model, that can combine several common tasks together, such as specifying the positions of the latent factors and adjusting the positions of the indicators. 

We also write the functions in a way that users do not need to know the technical detail (e.g., the position of the path in the list of all paths). For example, if a user wants to move the path coefficient of the path from `x` to `y` closer to `y`, the user only needs to tell the function that it is the path from `x` to `y`. The function will find which path it is in the `qgraph` object.

# What we have so far

- `mark_se()`: Add the standard errors to parameter estimates.

- `mark_sig()`: Add asterisks ("\*", "\*\*", "\*\*\*") based on $p$-values of parameter estimates.

- `rotate_resid()`: Rotate the residuals of selected variables.

- `set_curve()`: Change the curvature of selected paths.

- `set_edge_label_position()`: Move the parameter labels of selected paths along the paths.

- `set_cfa_layout()`: A function for typical confirmatory factor analysis models. It can be used for specifying the orders of the indicators and factors, specifying the positions of the factors, setting the curvatures of the interfactor covariances, set the position of all loadings, and setting the orientation of the model (down, left, up, or right).

- `set_sem_layout()`: A function for typical SEM models. It can be used for specifying the orders of the indicators and factors, specifying the positions of the factors using a grid, specifying the orientation of each factor's indicators (down, left, up, right), fine tuning the positions of indicators of selected factor, setting the curvatures of selected paths, and specifying the position of all or selected loadings.

# Status

This package is still under development. There will be bugs, and there are limitations. Comments and suggestions are welcomed.
