% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{print.semmcci}
\alias{print.semmcci}
\title{Print Method for Object of Class \code{semmcci}}
\usage{
\method{print}{semmcci}(x, digits = 4, ...)
}
\arguments{
\item{x}{an object of class \code{semmcci}.}

\item{digits}{Integer indicating the number of decimal places to display.}

\item{...}{further arguments.}
}
\value{
Returns a matrix of estimates, standard errors,
number of Monte Carlo replications, and confidence intervals.
}
\description{
Print Method for Object of Class \code{semmcci}
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
a <- 0.50
b <- 0.50
cp <- 0.25
s2_em <- 1 - a^2
s2_ey <- 1 - cp^2 - a^2 * b^2 - b^2 * s2_em - 2 * cp * a * b
em <- rnorm(n = n, mean = 0, sd = sqrt(s2_em))
ey <- rnorm(n = n, mean = 0, sd = sqrt(s2_ey))
X <- rnorm(n = n)
M <- a * X + em
Y <- cp * X + b * M + ey
df <- data.frame(X, M, Y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  Y ~ cp * X + b * M
  M ~ a * X
  indirect := a * b
  direct := cp
  total := cp + (a * b)
"
fit <- sem(data = df, model = model)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)
print(unstd)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
