% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cibound.R
\name{print.cibound}
\alias{print.cibound}
\title{Print Method of a 'cibound'-class Object}
\usage{
\method{print}{cibound}(x, digits = 5, ...)
}
\arguments{
\item{x}{The output of a \code{ci_bound_xx_i} function. Currently the
only such function is \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}.}

\item{digits}{The number of digits after the decimal point. To be
passed to \code{\link[=round]{round()}}. Default is 5.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the diagnostic information of a \code{cibound}-class
object.
}
\details{
This is the print method for the output of
\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}, a \code{cibound}-class object. It prints the
diagnostic information on the bound being found and the search
process.
}
\examples{
data(simple_med)
dat <- simple_med

mod <-
"
m ~ x
y ~ m
"

fit_med <- lavaan::sem(mod, simple_med, fixed.x = FALSE)

fn_constr0 <- set_constraint(fit_med)

out1l <- ci_bound_wn_i(i = 1,
                       npar = 5,
                       sem_out = fit_med,
                       f_constr = fn_constr0,
                       which = "lbound")

# Print the output
out1l

}
