% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearby_levels.R
\name{ci_order}
\alias{ci_order}
\alias{print.ci_order}
\title{Check The Order of Bounds in a List of \code{semlbci}
Objects}
\usage{
ci_order(semlbci_list)

\method{print}{ci_order}(x, digits = 3, ...)
}
\arguments{
\item{semlbci_list}{An object of class \code{semlbci_list},
such as the output of \code{\link[=nearby_levels]{nearby_levels()}}.}

\item{x}{The output of \code{\link[=ci_order]{ci_order()}}.}

\item{digits}{The number of decimal places in the printout.}

\item{...}{Additional arguments. Not used.}
}
\value{
A \code{ci_order}-class object with a \code{print} method
\code{\link[=print.ci_order]{print.ci_order()}}. The number of rows is equal to the
number of
parameters in \code{semlbci_list}, and the columns stores the
confidence limits from the list, ordered according to the
level of confidence.

\code{x} is returned invisibly. Called for its side effect.
}
\description{
Check whether the LBCIs in a list of
\code{semlbci}-class of objects are consistent with their
levels of confidence.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ci_order)}: The print method of the output of
\code{\link[=ci_order]{ci_order()}}.

}}
\examples{

library(lavaan)
mod <-
"
m ~ x
y ~ m
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
lbci_fit <- semlbci(fit_med)
lbci_fit_nb <- nearby_levels(lbci_fit,
                             ciperc_levels = c(-.050, .050))

# Check the order of the confidence bounds.
# A confidence interval with a higher level of confidence
# should enclose a confidence interval with
# a lower level of confidence.
ci_order(lbci_fit_nb)

}
\seealso{
\code{\link[=nearby_levels]{nearby_levels()}}, \code{\link[=semlbci]{semlbci()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
