% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_constructs.R
\name{multi_items}
\alias{multi_items}
\title{Multi-items measurement model specification}
\usage{
multi_items(item_name, item_numbers, ...)
}
\arguments{
\item{item_name}{Prefix name of items}

\item{item_numbers}{The range of number suffixews for the items}

\item{...}{Additional Item names and nubers}
}
\value{
A vector of numbered indicators.
}
\description{
\code{multi_items} creates a vector of measurment names given the item prefix and number range.
}
\examples{
  mobi_mm <- constructs(
    composite("Image",        multi_items("IMAG", 1:5), weights = correlation_weights),
    composite("Expectation",  multi_items("CUEX", 1:3), weights = mode_A),
    composite("Quality",      multi_items("PERQ", 1:7), weights = regression_weights),
    composite("Value",        multi_items("PERV", 1:2), weights = mode_B)
  )
}
\seealso{
See \code{\link{single_item}}
}
