% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_ifi.R
\name{show_cfi}
\alias{show_cfi}
\alias{show_tli}
\alias{show_ifi}
\title{Visualize How CFI and TLI Are Computed}
\usage{
show_cfi(fit, ...)

show_tli(fit, ...)

show_ifi(fit, fit_measures = c("cfi", "tli"), test = c("standard"))
}
\arguments{
\item{fit}{An output of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers
(e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}} and
\code{\link[lavaan:sem]{lavaan::sem()}}).}

\item{...}{Arguments to be passed to \code{\link[=show_ifi]{show_ifi()}}.}

\item{fit_measures}{The fit measures
to be plotted. Acceptable values are
\code{"cfi"} and \code{"tli"}.}

\item{test}{The type of model
chi-square test. It corresponds
to the \code{test} argument of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers.
Only \code{"standard"} is supported for now.}
}
\value{
An output of
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} that can be
further modified.
}
\description{
Show how CFI and TLI are
computed using a graph of model
chi-square vs. model degrees of
freedom.
}
\details{
This function receives an
output of \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its
wrappers (e.g., \code{\link[lavaan:cfa]{lavaan::cfa()}}
and \code{\link[lavaan:sem]{lavaan::sem()}}) and
illustrates how CFI is computed.
}
\section{Functions}{
\itemize{
\item \code{show_cfi()}: A wrapper of \code{\link[=show_ifi]{show_ifi()}} with \code{fit_measures = "cfi"}.

\item \code{show_tli()}: A wrapper of \code{\link[=show_ifi]{show_ifi()}} with \code{fit_measures = "tli"}.

}}
\examples{


library(lavaan)

# From the help page of lavaan::cfa().

HS.model <- '
visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9
'
fit <- cfa(HS.model, data = HolzingerSwineford1939)

# By default show how CFI is computed
show_ifi(fit)

# Show how TLI is computed
show_ifi(fit, fit_measures = "tli")

# Wrappers
show_cfi(fit)
show_tli(fit)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
