% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{has_css_property}
\alias{has_css_property}
\title{Does an element's css property match a value?}
\usage{
has_css_property(x, property, value)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{property}{The name of the CSS property}

\item{value}{The value of the attribute.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
Check that the CSS property (e.g. \code{"background-color"}) of an element matches
a value.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div style='display:none;'></div>
"
session <- minimal_selenider_session(html)

has_css_property(s("div"), "display", "none")

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
