% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{is_enabled}
\alias{is_enabled}
\alias{is_disabled}
\title{Is an element enabled?}
\usage{
is_enabled(x)

is_disabled(x)
}
\arguments{
\item{x}{A \code{selenider_element} object.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
\code{is_disabled()} checks that an element has the \code{disabled} attribute set to
\code{TRUE}, while \code{is_enabled()} checks that it does not. Both functions throw an
error if the element does not exist in the DOM.
}
\details{
These functions do not implement a retry mechanism, and only test a condition
once. Use \code{\link[=elem_expect]{elem_expect()}} or \code{\link[=elem_wait_until]{elem_wait_until()}} to use these conditions in
tests.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<button></button>
<button disabled></button>
"

session <- minimal_selenider_session(html)

is_enabled(s("button")) # TRUE

is_disabled(ss("button")[[2]]) # TRUE

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
