% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{close_session}
\alias{close_session}
\title{Close a session object}
\usage{
close_session(x = NULL)
}
\arguments{
\item{x}{A \code{selenider_session} object. If omitted, the local session object
will be closed.}
}
\value{
Nothing.
}
\description{
Shut down a session object, closing the browser and stopping the server.
This will be done automatically if the session is set as the local session
(which happens by default).
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session(local = FALSE)

close_session(session)

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup(FALSE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=selenider_session]{selenider_session()}}
}
