% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_main.R
\docType{methods}
\name{selectLocalOptimalSNPs}
\alias{selectLocalOptimalSNPs}
\alias{selectLocalOptimalSNPs,numeric-method}
\alias{selectLocalOptimalSNPs,Chrom-method}
\alias{selectLocalOptimalSNPs,Map-method}
\title{Select locally-optimized SNPs on one or more chromosomes}
\usage{
selectLocalOptimalSNPs(object, ...)

\S4method{selectLocalOptimalSNPs}{numeric}(object, f, n, t1 = 1, t2 = 1, w1 = 0.5, w2 = 0.5)

\S4method{selectLocalOptimalSNPs}{Chrom}(object, n, t1 = 1, t2 = 1, w1 = 0.5, w2 = 0.5)

\S4method{selectLocalOptimalSNPs}{Map}(object, n, t1 = 1, t2 = 1, w1 = 0.5, w2 = 0.5)
}
\arguments{
\item{object}{An input object, which can be a vector of map positions, a Chrom object, a Map object,
or a data frame containing map information for all the candidate SNPs.}

\item{...}{Extra input parameters, as needed.}

\item{f}{A vector of minor allele frequencies for all the candidate SNPs.}

\item{n}{NUmber of SNP positions to be filled.}

\item{t1}{A penalty parameter (0~100) for the E score, which by default is 1.}

\item{t2}{A shrinkage parameter (0-100) for the U score, which by default is 1.}

\item{w1}{A weight for the impact of MAF on selecting markers, which by default is 0.5.}

\item{w2}{A weight for the impact of map position on selecting markers, which by default is 0.5.}
}
\value{
A \code{Map} object with locally-optimal SNPs when the input is a \code{Map} object, or a
\code{Chrom} object with locally-optimal SNPs when the input is a \code{Chrom} object, or a vector
of map positions of locally-optimal SNPs when the input are a vector of map positions of SNPs.
}
\description{
This function is used to select locally-optimal SNPs using an unified, local function 
uder varied scenarios. The idea is to divide each chromosome into equal segments, and within each 
segment, an local optimal SNP is selected as the one having the largest weighted score between the 
uniformmness (U score) and a function (average Shannon entropy, or E score) of minor allele frequency. 
If the weight for the E score is zero, it selects (approximately) uniformly-distributed SNPs. If the
weight for the U score is zero, it selects SNPs with the largest minor allele frequencies within 
pre-defined local chromosome regions or bins.
}
\examples{
\donttest{
data(bov80K)
map1<-selectLocalOptimalSNPs(bov80K,bin=1,n=1000,w1=0,w2=1)
plot(map1)
scoreU(map1)
scoreE(map1)

map2<-selectLocalOptimalSNPs(bov80K,bin=2,n=1000,w1=0,w2=1)
plot(map2)
scoreU(map2)
scoreE(map2)

map3<-selectLocalOptimalSNPs(bov80K,bin=4,n=1000,w1=0.5,w2=0.5)
plot(map3)
scoreU(map3)
scoreE(map3)
} 

}
\references{
{
    1. Wu X-L, Li H, Ferretti R, Simpson B, Walker J, Parham J, Mastro L, Qiu J, Schultz T, Tait
RG. Jr., and Bauck S. (2020) A unified local objective function for optimally selecting SNPs on arrays
 for agricultural genomics applications. Anim. Genet. (in press)

    2. Wu XL, Xu J, Feng G, Wiggans GR, Taylor JF, He J, Qian C, Qiu J, Simpson B, Walker J,
 Bauck S. Optimal Design of Low-Density SNP Arrays for Genomic Prediction: Algorithm and Applications.
 PLoS One. 2016, 11(9):0161719. doi: 10.1371/journal.pone.0161719. eCollection 2016.
 }
}
\author{
Nick X-L Wu
}
