% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deputies_add_new.R
\name{deputies_add_new}
\alias{deputies_add_new}
\title{Adding new deputies to table}
\usage{
deputies_add_new(dbname, user, password, host, type, id,
  nr_term_of_office = 8)
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{type}{type of deputies which be add to table with deputies: active, inactive}

\item{id}{id of deputies from which we start add new deputies}

\item{nr_term_of_office}{number of term of office of Polish Diet; default: 8}
}
\value{
invisible NULL
}
\description{
Function \code{deputies_add_new} adds new deputies to a table with deputies.
}
\details{
Function \code{deputies_add_new} adds new deputies to a table with deputies.
Also there is a choice between types of deputies, because on the page 
of Polish diet deputies are splitted into \emph{active} and \emph{inactive}.
In addition id of the last added deputy in \emph{deputies} table is needed.
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
deputies_add_new(dbname, user, password, host, 'active', id)
deputies_add_new(dbname, user, password, host, 'inactive', id)}

}
\author{
Piotr Smuda
}

