% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/votes_create_table.R
\name{votes_create_table}
\alias{votes_create_table}
\title{Creating table with votes}
\usage{
votes_create_table(dbname, user, password, host,
  home_page = 'http://www.sejm.gov.pl/Sejm7.nsf/',
  windows = .Platform$OS.type == 'windows')
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{home_page}{main page of polish diet: http://www.sejm.gov.pl/Sejm7.nsf/}

\item{windows}{information of used operation system;
default: .Platform$OS.type == 'windows'}
}
\value{
invisible NULL
}
\description{
Function \code{votes_create_table} creates a table with votes.
}
\note{
Use only this function for first time, when the \emph{votes} table
is empty. Then use \code{votes_update_table}.

There is a possibility that someone's voice reader broke during voting
and this situation is treated like this deputy was absent. Even if deputy
made a decision, he's/she's vote is 'Nieobecny'.

All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
home_page <- http://www.sejm.gov.pl/Sejm7.nsf/
votes_create_table(dbname, user, password, host, home_page, TRUE)
votes_create_table(dbname, user, password, host, home_page, FALSE)}
}
\author{
Piotr Smuda
}

