% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmetric.R
\name{segmetric_functions}
\alias{segmetric_functions}
\alias{.segmetric_check}
\alias{.segmetric_env}
\alias{sm_read}
\alias{sm_clear}
\alias{summary.segmetric}
\alias{sm_is_empty}
\title{General functions}
\usage{
.segmetric_check(m)

.segmetric_env(m)

sm_read(ref_sf, seg_sf)

sm_clear(m)

\method{summary}{segmetric}(object, ...)

sm_is_empty(m)
}
\arguments{
\item{m}{A \code{segmetric} object.}

\item{ref_sf}{A \code{sf} object. The reference polygons.}

\item{seg_sf}{A \code{sf} object. The segmentation polygons.}

\item{object}{A \code{segmetric} object.}

\item{...}{Additional parameters (Not implemented).}
}
\value{
\itemize{
\item \code{sm_read()}, \code{sm_clear()}: Return a \code{segmetric} object containing an
empty list and an environment attribute to store the necessary datasets.
\item \code{sm_is_empty()}: Return a \code{logical} vector indicating if each computed
metric is empty.
}
}
\description{
These functions manipulate \code{segmetric} objects.
\itemize{
\item \code{sm_read()}: Load the reference and segmentation polygons into segmetric.
\item \code{sm_clear()}: Remove the already calculated metrics from segmetric.
\item \code{print()}: Print a segmetric object.
\item \code{plot()}: Plot the reference and segmentation polygons.
\item \code{summary()}: Compute a measure of central tendency over the values of a metric.
\item \code{sm_is_empty()}: Check if a \code{segmetric} object is empty.
}
}
\examples{
# load sample datasets
data("sample_ref_sf", package = "segmetric")
data("sample_seg_sf", package = "segmetric")

# create segmetric object
m <- sm_read(ref_sf = sample_ref_sf, seg_sf = sample_seg_sf)

# plot geometries
plot(m)

# compute a metric
sm_compute(m, "AFI")

# summarize the metric using mean
sm_compute(m, "AFI") \%>\% summary()

# clear computed subsets
sm_clear(m)

}
\seealso{
\code{sm_compute()}
}
\keyword{internal}
