% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bootstrap_critical_cutoffs}
\alias{bootstrap_critical_cutoffs}
\title{Bootstrap critical segmentation magnitude}
\usage{
bootstrap_critical_cutoffs(segmag, n_bootstrap, critical_probs,
  segmag_substract = NULL, visualize = FALSE, save_as = NULL)
}
\arguments{
\item{segmag}{object of class \code{\link{segmag}}}

\item{n_bootstrap}{numeric, number of bootstrap iterations}

\item{critical_probs}{numeric vector of probabilities, e.g. c(.95,.99)}

\item{segmag_substract}{object of class \code{\link{segmag}}. If this value is set
than keypress times in segmag and segmag_substract are
both randomized and the critical_cutoffs relate to
the difference of the segmentation magnitude in segmag
minus the segmentation magnitude in segmag_substract}

\item{visualize}{logical, visualize ordered maxima (and minima if segmag_substract
is set) of bootstrapping iterations (Note: Enabling this option
might require a lot of RAM with large data sets or large values
of n_bootstrap)}

\item{save_as}{character, filename where to save raw bootstrapping data and
plot (optional)}
}
\value{
critical segmentation magnitudes; If segmag_substract is NULL, then
        the return value is a numeric vector. Otherwise a list with critical
        maxima cutoffs and critical minima cutoffs is returned.
}
\description{
Bootstraps critical segmentation magnitude values for a \code{\link{segmag}}
object under the null hypothesis that all key presses were randomly
distributed (uniformly) across the experiment (time_min to time_max).
}
\details{
During each bootstrapping iteration, the key presses are randomly distributed
(drawn from uniform distribution ranging from time_min to time_max). Then,
segmentation magnitude is calculated with those random key press times (note
that ids are retained, that is each participant "makes" the same amount of
key presses as in the original experiment). The local maxima in segmentation
magnitude resulting from the random key press times are ordered according to
their size. The largest maximum is kept.

The function returns the \code{critical_probs} quantiles of the vector of those
largest maxima obtained across \code{n_bootstap} iterations

This function can also be used to bootstrap the critical maxima and minima
cutoffs of a difference function of two segmag objects. To do so, segmag and
segmag_substract must be defined. All values will be related to the difference
of segmag - segmag_substract (Keypress times in segmag and segmag_substract are
randomizes independently).
}
\examples{
#see ?segmag for an example
}
\seealso{
\code{\link{get_eb_times}}, \code{\link{segmag}}
}

