% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_prepare.R
\name{stat_segm}
\alias{stat_segm}
\title{Calculate statistics on a given segmentation}
\usage{
stat_segm(
  data,
  diag.var,
  order.var = NULL,
  param = NULL,
  seg.type = NULL,
  nseg
)
}
\arguments{
\item{data}{the data.frame with the different variable}

\item{diag.var}{names of the variables on which statistics are calculated}

\item{order.var}{names of the variable with which states are ordered}

\item{param}{parameters of output segmentation}

\item{seg.type}{either 'hybrid' or 'dynprog'}

\item{nseg}{number of segment chosen}
}
\value{
a list which first element is a data.frame with states of the
  different segments and which second element is a data.frame with mean and
  variance of the different states
}
\description{
\code{stat_segm} calculates statistics of a given segmentation : mean and
variance of the different states. it also creates standard objects for plot.
}
\examples{
\dontrun{
#res.segclust is a result of a segmentation-clustering algorithm
param <- res.segclust$param[["3 class"]]
nseg = 10
out <- stat_segm(data, diag.var = c("dist","angle"),
 order.var = "dist", param = param, nseg=nseg, seg.type = "segclust")

}
}
