% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segclust.R
\name{segclust}
\alias{segclust}
\alias{segclust.data.frame}
\alias{segclust.Move}
\alias{segclust.ltraj}
\title{Segmentation/Clustering of movement data - Generic function}
\usage{
segclust(x, ...)

\method{segclust}{data.frame}(x, ...)

\method{segclust}{Move}(x, ...)

\method{segclust}{ltraj}(x, ...)
}
\arguments{
\item{x}{data.frame with observations}

\item{...}{additional parameters given to \code{\link{segclust_internal}}.}
}
\value{
a \code{\link{segmentation-class}} object
}
\description{
Joint Segmentation/Clustering of movement data. Method available for
data.frame, move and ltraj objects. The algorithm finds the optimal
segmentation for a given number of cluster and segments using an iterated
alternation of a Dynamic Programming algorithm and an
Expectation-Maximization algorithm. Among the different segmentation found,
the best one can be chosen using the maximum of a BIC penalized likelihood.
}
\examples{
#' @examples
df <-  test_data()$data
#' # data is a data.frame with column 'x' and 'y'
# Simple segmentation with automatic subsampling 
# if data has more than 1000 rows:
res <- segclust(df,
 Kmax = 15, lmin = 10, ncluster = 2:4, 
 seg.var = c("x","y"))
 # Plot results
 plot(res)
 segmap(res, coord.names = c("x","y"))
 # check penalized likelihood of 
 # alternative number of segment possible. 
 # There should be a clear break if the segmentation is good
 plot_BIC(res)
\dontrun{
# Advanced options:
# Run with automatic subsampling if df has more than 500 rows:
res <- segclust(df, Kmax = 30, lmin = 10, ncluster = 2:4,
                seg.var = c("x","y"), subsample_over = 500)
# Run with subsampling by 2:
res <- segclust(df, Kmax = 30, lmin = 10, ncluster = 2:4,
                seg.var = c("x","y"), subsample_by = 2)
# Disable subsampling:
res <- segclust(df, Kmax = 30, lmin = 10, 
                ncluster = 2:4, seg.var = c("x","y"), subsample = FALSE)
# Disabling automatic scaling of variables for segmentation (standardazing
# the variables) :
 res <- segclust(df, Kmax = 30, lmin = 10,
                 seg.var = c("dist","angle"), scale.variable = FALSE)
}
}
