% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation}
\alias{segmentation}
\alias{segmentation.data.frame}
\alias{segmentation.Move}
\alias{segmentation.ltraj}
\title{Segmentation of movement data - Generic function}
\usage{
segmentation(x, ...)

\method{segmentation}{data.frame}(x, Kmax, lmin, type = "home-range",
  seg.var, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("x", "y"), ...)

\method{segmentation}{Move}(x, Kmax, lmin, type = "home-range",
  seg.var = NULL, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("coords.x1", "coords.x2"), ...)

\method{segmentation}{ltraj}(x, Kmax, lmin, type = "home-range",
  seg.var = NULL, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("x", "y"), ...)
}
\arguments{
\item{x}{data used for segmentation. Supported: data.frame, Move object,
ltraj object}

\item{...}{additional parameters given to \code{\link{segmentation_internal}}}

\item{Kmax}{maximum number of segments.}

\item{lmin}{minimum length of segments.}

\item{type}{type of segmentation. Either "home-range" or "behavior". Changes
default values of arguments order, scale.variable in the different
functions used on the output. Default for segmentation: "home-range";
default for segmentation/clustering : "behavior".}

\item{seg.var}{for behavioral segmentation: names of the variables used for
segmentation (either one or two names).}

\item{diag.var}{for behavioral segmentation: names of the variables on which
statistics are calculated.}

\item{order.var}{for behavioral segmentation: names of the variable with
which states are ordered.}

\item{coord.names}{for home-range segmentation and data.frame, names of coordinates. Default x and y. Not needed for move and ltraj objects}
}
\value{
a \code{\link{segmentation-class}} object
}
\description{
Segmentation of movement data. No clustering. Method available for
data.frame,  move and ltraj object. The algorithm finds for each number of
segment the optimal segmentation using a Dynamic Programming approach. The
number of segment is then chosen using Lavielle's (2005) procedure based on
locating rupture in the penalized likelihood.
}
\examples{
df <-  test_data()$data
#' # data is a data.frame with column 'x' and 'y'
# Simple segmentation with automatic subsampling if data has more than 1000 rows:
res <- segmentation(df, Kmax = 30, lmin = 10, coord.names = c("x","y"), 
type = 'home-range')
 # Plot results
 plot(res)
 segmap(res)
 # check likelihood of alternative number of segment possible. There should
 # be a clear break if the segmentation is good
 plot_likelihood(res)
\dontrun{
# Advanced options:
# Run with automatic subsampling if df has more than 500 rows:
res <- segmentation(df, Kmax = 30, lmin = 10, coord.names = c("x","y"), 
type = 'home-range', subsample_over = 500)

# Run with subsampling by 2:
res <- segmentation(df, Kmax = 30, lmin = 10, coord.names = c("x","y"),
 type = 'home-range', subsample_by = 2)
 
# Disable subsampling:
res <- segmentation(df, Kmax = 30, lmin = 10, coord.names = c("x","y"), 
type = 'home-range', subsample = FALSE)

# Run on other kind of variables : 
 res <- segmentation(df, Kmax = 30, lmin = 10, seg.var = c("dist","angle"), 
 type = 'behavior')
 
# Automatic scaling of variables for segmentation 
(set a mean of 0 and a standard deviation of 1 for both variables)

 res <- segmentation(df, Kmax = 30, lmin = 10, seg.var = c("dist","angle"),
  type = 'behavior', scale.variable = TRUE)
 
}
}
