% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print_cli}
\alias{print_cli}
\title{Should CLI Output Be Printed?}
\usage{
print_cli()
}
\value{
A logical scalar: \code{TRUE} if CLI output should be shown, \code{FALSE} otherwise.
}
\description{
Determines whether CLI progress or messaging functions should be executed.
This helper evaluates the \code{seekr.verbose} option, checks for an interactive session,
and disables output during testthat tests.
}
\details{
This function is designed to control conditional CLI output (e.g., \code{\link[cli:cli_progress_step]{cli::cli_progress_step()}}).
It returns \code{TRUE} only when:
\itemize{
\item \code{getOption("seekr.verbose", TRUE)} is \code{TRUE}
\item the session is interactive (\code{interactive()})
\item testthat is not running (\code{!testthat::is_testing()})
}
}
\keyword{internal}
