% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classOdeEquation.R
\docType{class}
\name{odeEquations-class}
\alias{odeEquations-class}
\alias{odeEquations}
\title{A S4 class used to handle formatting ODE-Equation and calculate the needed functions for the seeds-algorithm}
\value{
Returns a s4 class object containing the needed equations for the costate equation
}
\description{
A S4 class used to handle formatting ODE-Equation and calculate the needed functions for the seeds-algorithm
}
\section{Slots}{

\describe{
\item{\code{modelStr}}{a vector of strings describing the ODE}

\item{\code{measureStr}}{a vector of strings representing the equation of the measurement function}

\item{\code{origEq}}{a vector of strings containing the original model function}

\item{\code{measureFunction}}{a vector of strings containing the original measurement function}

\item{\code{costateEq}}{a vector of strings describing the costate equation}

\item{\code{JhT}}{a matrix of strings describing the jacobian matrix of the measurement function}

\item{\code{jacobian}}{a matrix of strings representing the jacobian matrix model equations}

\item{\code{costFunction}}{a string containing the cost function}

\item{\code{hamiltonian}}{a string representing the Hamilton function of the model}

\item{\code{dynamicElasticNet}}{boolean that indicates if the system equation should be calculated for the dynamic elastic net}

\item{\code{parameters}}{parameters of the model}

\item{\code{cond}}{a slot to save conditionals in equations, which are used for formatting the c files}

\item{\code{nnStates}}{vector indicating which states should have a non negative solution}
}}

