% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDEN.R
\name{BDEN}
\alias{BDEN}
\title{Bayesian Dynamic Elastic Net}
\usage{
BDEN(
  odeModel,
  settings,
  mcmc_component,
  loglikelihood_func,
  gibbs_update,
  ode_sol,
  NegativeStates = FALSE,
  numbertrialsstep = 15,
  numbertrialseps = NA,
  numbertrialinner = 25,
  lambda = 0.001,
  Grad_correct = 0,
  alpha = c(1, 1, 1, 1),
  beta_init = c(1, 1, 1, 1),
  printstatesignore = FALSE
)
}
\arguments{
\item{odeModel}{a object of class odeModel from the package seeds. The class saves the details of an experiment for easier manipulation and analysis.}

\item{settings}{initial model specific settings (automatically calculated based on the nominal model and data)}

\item{mcmc_component}{sampling algorithm}

\item{loglikelihood_func}{likelihood function}

\item{gibbs_update}{gibbs algorithm}

\item{ode_sol}{ode solver}

\item{NegativeStates}{Negative states are allowed}

\item{numbertrialsstep}{number of gibbs updates per timepoint. This should be at least 10. Values have direct influnce on the runtime.}

\item{numbertrialseps}{number of samples per mcmc step. This should be greater than numberStates*500.Values have direct influnce on the runtime.}

\item{numbertrialinner}{number of inner samples. This should be greater 15 to guarantee a reasonable exploration of the sample space. Values have direct influnce on the runtime.}

\item{lambda}{initial shrinkage parameter.}

\item{Grad_correct}{correction factor for initial sigma estimate}

\item{alpha}{mcmc tuning parameter (weighting of observed states)}

\item{beta_init}{mcmc tuning parameter (weigthing of observed states)}

\item{printstatesignore}{states ignored in final output (default = FALSE)}
}
\value{
returns a results-object with default plot function
}
\description{
Full Bayesian algorithm to detect hidden inputs in ODE based models.The algorithm 
is an extension of the Dynamic Elastic Net algorithm (Engelhardt et al. 2016) inspired by the Elastic-Net Regression.
}
\details{
Ordinary differential equations (ODEs) are a popular approach to quantitatively model molecular networks based on biological knowledge. 
However, such knowledge is typically restricted. Wrongly modelled biological mechanisms as well as relevant external influence factors 
that are not included into the model likely manifest in major discrepancies between model predictions and experimental data. 
Finding the exact reasons for such observed discrepancies can be quite challenging in practice. 
In order to address this issue we suggest a Bayesian approach to estimate hidden influences in ODE based models. 
The method can distinguish between exogenous and endogenous hidden influences. Thus, we can detect wrongly specified as well as missed 
molecular interactions in the model. 
The BDEN as a new and fully probabilistic approach, supports the modeller in an algorithmic manner to identify possible sources of errors 
in ODE based models on the basis of experimental data.  THE BDEN does not require pre-specified hyper-parameters. 
BDEN thus provides a systematic Bayesian computational method to identify target nodes and reconstruct the corresponding 
error signal including detection of missing and wrong molecular interactions within the assumed model. 
The method works for ODE based systems even with uncertain knowledge and noisy data. 
In contrast to approaches based on point estimates the Bayesian framework incorporates the given uncertainty and circumvents 
numerical pitfalls which frequently arise from optimization methods (Engelhardt et al. 2017).

For a complete example of the usage take a look into the vignette of the package.
}
\examples{
\donttest{
data(bden_uvb)

results <- BDEN(odeModel          = Model,
                lambda            = .001,
                beta_init         = c(1,1,1,1,1),
                numbertrialsstep  = 15,
                numbertrialseps   = 2000,
                numbertrialinner  = 10)
}

}
