% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_model.R
\name{normal_model}
\alias{normal_model}
\title{Analysis: Normal model}
\usage{
normal_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  error = "SE",
  legend.position = "top",
  cardinal = 0,
  r2 = "all",
  width.bar = NA,
  scale = "none"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{cardinal}{defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns the coefficients and respective p-values; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean squared error); cardinal and optimal temperatures and the graph using ggplot2 with the equation.
}
\description{
Analysis: Normal model
}
\details{
The model function for the normal model is:
\deqn{f(x) = a \epsilon^{-\frac{(x-b)^2)}{c^2}}}
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
normal_model(trat,germ)

#================================
# Germination speed
#================================
normal_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
