% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_radar.R
\name{coord_radar}
\alias{coord_radar}
\title{Radar coordinate system}
\usage{
coord_radar(theta = "x", start = 0, direction = 1, ...)
}
\arguments{
\item{theta}{variable to map angle to (\code{x} or \code{y})}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{direction}{1, clockwise; -1, anticlockwise}

\item{...}{Other arguments to be passed to \code{ggproto}.}
}
\description{
Add a radar coordinate system useful for radar charts.
}
\examples{
\dontshow{if (require("datawizard") && require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a radar/spider chart with ggplot:
data(iris)
data <- aggregate(iris[-5], list(Species = iris$Species), mean)
data <- data_to_long(
  data,
  c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
)

ggplot(data, aes(x = name, y = value, color = Species, group = Species)) +
  geom_polygon(fill = NA, linewidth = 2) +
  coord_radar(start = -pi / 4)
\dontshow{\}) # examplesIf}
}
