% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.describe_distribution.R
\name{plot.see_parameters_distribution}
\alias{plot.see_parameters_distribution}
\title{Plot method for describing distributions of vectors}
\usage{
\method{plot}{see_parameters_distribution}(
  x,
  dispersion = FALSE,
  dispersion_alpha = 0.3,
  dispersion_color = "#3498db",
  dispersion_style = c("ribbon", "curve"),
  size_bar = 0.7,
  highlight = NULL,
  highlight_color = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{dispersion}{Logical, if \code{TRUE}, will add range of dispersion for each variable to the plot.}

\item{dispersion_alpha}{Transparency level of dispersion ribbon.}

\item{dispersion_color}{Color of dispersion ribbon.}

\item{dispersion_style}{Character, style of dispersion area. \code{"ribbon"} for a ribbon, \code{"curve"} for a normal-curve.}

\item{size_bar}{Size of bar geoms.}

\item{highlight}{Vector with names of categories in \code{x} that should be highlighted.}

\item{highlight_color}{Vector of color values for highlighted categories. The remaining (non-highlighted) categories will be filled with a lighter grey.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::describe_distribution()} function.
}
\examples{
library(parameters)
set.seed(333)
x <- sample(1:100, 1000, replace = TRUE)
result <- describe_distribution(x)
result
plot(result)
}
