% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.compare_performance.R
\name{plot.see_compare_performance}
\alias{plot.see_compare_performance}
\title{Plot method for comparing model performances}
\usage{
\method{plot}{see_compare_performance}(x, size = 1, ...)
}
\arguments{
\item{x}{An object.}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::compare_performance()} function.
}
\examples{
library(performance)
data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
result <- compare_performance(lm1, lm2, lm3)
result
plot(result)
}
