% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plot.R
\name{add_plot_attributes}
\alias{add_plot_attributes}
\title{Complete figure with its attributes}
\usage{
add_plot_attributes(x)
}
\arguments{
\item{x}{An object.}
}
\description{
The \link{data_plot} function usually stores information (such as title, axes labels etc.) as attributes. This function adds those information to the plot.
}
\examples{
library(rstanarm)
library(bayestestR)
library(see)
library(ggplot2)

model <- stan_glm(
  Sepal.Length ~ Petal.Width + Species + Sepal.Width,
  data = iris,
  chains = 2, iter = 200
)

result <- hdi(model, ci = c(0.5, 0.75, 0.9, 0.95))
data <- data_plot(result, data = model)

p <- data \%>\%
  ggplot(aes(x = x, y = y, height = height, group = y, fill = fill)) +
  ggridges::geom_ridgeline_gradient()

p
p + add_plot_attributes(data)


}
